/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.collect.Sets;
import committee.nova.mods.avaritia.api.common.item.ItemStackWrapper;
import committee.nova.mods.avaritia.common.item.MatterClusterItem;
import committee.nova.mods.avaritia.util.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ClustersUtils {
    public static Set<String> defaultTrashOres = Sets.newHashSet((Object[])new String[]{"minecraft:dirt"});

    public static void spawnClusters(Level world, Player player, Set<ItemStack> drops) {
        if (!world.f_46443_) {
            List<ItemStack> clusters = MatterClusterItem.makeClusters(drops);
            for (ItemStack cluster : clusters) {
                Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)(player.m_20186_() + 0.5), (double)player.m_20189_(), (ItemStack)cluster);
            }
        }
    }

    public static void spawnClusters(Level world, Player player, Map<ItemStack, Integer> map) {
        if (!world.f_46443_) {
            HashSet<ItemStack> stacks = new HashSet<ItemStack>();
            map.forEach((stack, integer) -> stacks.add(stack.m_255036_(((Integer)map.get(stack)).intValue())));
            List<ItemStack> clusters = MatterClusterItem.makeClusters(stacks);
            for (ItemStack cluster : clusters) {
                Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)cluster);
            }
        }
    }

    public static void putMapItem(ItemStack drop, Map<ItemStack, Integer> map) {
        ItemStack itemStack = ItemUtils.mapEquals(drop, map);
        if (!itemStack.m_41619_()) {
            map.put(itemStack, map.get(itemStack) + drop.m_41613_());
        } else {
            map.put(drop, drop.m_41613_());
        }
    }

    public static void putMapDrops(Level world, BlockPos pos, Player player, ItemStack stack, Map<ItemStack, Integer> map) {
        for (ItemStack drop : Block.m_49874_((BlockState)world.m_8055_(pos), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)stack)) {
            ClustersUtils.putMapItem(drop, map);
        }
    }

    public static Set<ItemStack> removeTrash(Set<ItemStack> drops) {
        HashSet<ItemStack> trashItems = new HashSet<ItemStack>();
        for (ItemStack drop : drops) {
            if (!ClustersUtils.isTrash(drop)) continue;
            trashItems.add(drop);
        }
        drops.removeAll(trashItems);
        return drops;
    }

    private static boolean isTrash(ItemStack suspect) {
        boolean isTrash = false;
        for (String ore : defaultTrashOres) {
            if (!suspect.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ore)))) continue;
            return true;
        }
        return isTrash;
    }

    public static List<ItemStack> collateDropList(Set<ItemStack> input) {
        return ClustersUtils.collateMatterClusterContents(ClustersUtils.collateMatterCluster(input));
    }

    public static List<ItemStack> collateMatterClusterContents(Map<ItemStackWrapper, Integer> input) {
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStackWrapper, Integer> e : input.entrySet()) {
            int count = e.getValue();
            ItemStackWrapper wrap = e.getKey();
            int size = wrap.stack.m_41741_();
            int fullstacks = Mth.m_14143_((float)((float)count / (float)size));
            for (int i = 0; i < fullstacks; ++i) {
                count -= size;
                ItemStack stack = wrap.stack.m_41777_();
                stack.m_41764_(size);
                collated.add(stack);
            }
            if (count <= 0) continue;
            ItemStack stack = wrap.stack.m_41777_();
            stack.m_41764_(count);
            collated.add(stack);
        }
        return collated;
    }

    public static Map<ItemStackWrapper, Integer> collateMatterCluster(Set<ItemStack> input) {
        HashMap<ItemStackWrapper, Integer> counts = new HashMap<ItemStackWrapper, Integer>();
        if (input != null) {
            for (ItemStack entity : input) {
                ItemStackWrapper wrap = new ItemStackWrapper(entity);
                if (!counts.containsKey(wrap)) {
                    counts.put(wrap, 0);
                }
                counts.put(wrap, (Integer)counts.get(wrap) + entity.m_41613_());
            }
        }
        return counts;
    }
}

